﻿<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Place" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Lista płac dodatków</title>
		<script runat="server">

    static bool hideOperator = false;

    public class Params : ContextBase {
    
        public Params(Context context) : base(context) {
            okres = ((OkresContext)context[typeof(OkresContext)]).Okres;
        }

        FromTo okres;
        [Priority(10)]
        public FromTo Okres {
            get { return okres; }
        }        
        
        RodzajŹródłaWypłaty rodzajŹródła = RodzajŹródłaWypłaty.Etat;
        [Priority(20)]
        [Required]
        public RodzajŹródłaWypłaty RodzajŹródła {
            get { return rodzajŹródła; }
            set {
                rodzajŹródła = value;
                definicja = null;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListRodzajŹródła() {
            return new RodzajŹródłaWypłaty[] {
                RodzajŹródłaWypłaty.Etat,
                RodzajŹródłaWypłaty.Dodatek,
                RodzajŹródłaWypłaty.Nieobecność
                };
        }

        internal Row definicja;
        [Priority(30)]
        public DefinicjaElementu DefinicjaElementu {
            get { return definicja as DefinicjaElementu; }
            set {
                definicja = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListDefinicjaElementu() {
            return DefElementow.Elementy(this, rodzajŹródła);
        }

        public bool IsReadOnlyDefinicjaElementu() {
            return RodzajŹródła == RodzajŹródłaWypłaty.Nieobecność;
        }
        
        [Priority(40)]
        public DefinicjaNieobecnosci DefinicjaNieobecności {
            get { return definicja as DefinicjaNieobecnosci; }
            set {
                definicja = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public object GetListDefinicjaNieobecności() {
            return DefNieobecnosci.AktywneDefinicje(this);
        }

        public bool IsReadOnlyDefinicjaNieobecności() {
            return RodzajŹródła != RodzajŹródłaWypłaty.Nieobecność;
        }
    }
    
    FromTo okres;
    RodzajŹródłaWypłaty rodzajŹródła;
    Row definicja;
    [Context]
    public Params Pars {
		set {
            okres = value.Okres;
            rodzajŹródła = value.RodzajŹródła;
            definicja = value.definicja;
        }
    }

    bool msg;
            
    void dc_ContextLoad(Object sender, EventArgs e) {
        ReportHeader1["ŹRÓDŁO"] = CaptionAttribute.EnumToString(rodzajŹródła);

        if (definicja == null)
            ReportHeader1["DEFINICJA"] = "&nbsp;";
        else if (definicja is DefinicjaNieobecnosci)
            ReportHeader1["DEFINICJA"] = "|</strong>Definicja nieobecności: <strong>" + definicja;
        else
            ReportHeader1["DEFINICJA"] = "|</strong>Definicja elementu: <strong>" + definicja;

        ArrayList list = new ArrayList();

		Row[] rows = (Row[])dc[typeof(Row[])];
        foreach (Pracownik pracownik in rows) {
            bool any = false;
            switch (rodzajŹródła) {
                case RodzajŹródłaWypłaty.Etat:
                    any = TestEtat(pracownik);
                    break;
                case RodzajŹródłaWypłaty.Dodatek:
                    any = TestDodatki(pracownik);
                    break;
                case RodzajŹródłaWypłaty.Nieobecność:
                    any = TestNieobecnosci(pracownik);
                    break;
            }
            if (any) list.Add(pracownik);
        }

        Grid.DataSource = list;

        if (msg) ReportHeader1.Title += "|Wydruk przygotowany na podstawie danych, do których operator ma prawa dostępu";
    }

    void Grid_BeforeRow(object sender, Soneta.Web.RowEventArgs args) {
        Pracownik pracownik = (Pracownik)args.Row;

        switch (rodzajŹródła) {
            case RodzajŹródłaWypłaty.Etat:
                TestEtat(pracownik);
                break;
            case RodzajŹródłaWypłaty.Dodatek:
                TestDodatki(pracownik);
                break;
            case RodzajŹródłaWypłaty.Nieobecność:
                TestNieobecnosci(pracownik);
                break;
        }
    }

    bool TestEtat(Pracownik pracownik) {
        bool any = false;
        foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(okres))
            if (definicja == null || ph.Etat.Zaszeregowanie.Element == definicja)
                any |= Add(pracownik, ph.Etat.EfektywnyOkres, ph.Etat.Zaszeregowanie.Element);
        return any;
    }

    bool TestDodatki(Pracownik pracownik) {
        bool any = false;
        foreach (Dodatek dodatek in pracownik.Dodatki)
            foreach (DodHistoria dh in dodatek.Historia.GetIntersectedRows(okres))
                if (definicja == null || dh.Element == definicja)
                    any |= Add(dodatek, dh.EfektywnyOkres, dh.Element);
        return any;
    }

    bool TestNieobecnosci(Pracownik pracownik) {
        bool any = false;
        foreach (OkresNieobecności on in pracownik.Czasy.Nieobecnosci(okres, true))
            if (definicja == null || on.Definicja == definicja)
                any |= Add((Nieobecnosc)on, on.Okres, on.Definicja);
        return any;
    }

    bool Add(IBazaZrodlaWyplaty baza, FromTo oh, Row definicja) {
        oh = oh * okres;
        Periods ps = Periods.New(oh);
        SubTable st = PlaceModule.GetInstance(baza).WypElementy.WgBazaZrodla[baza, rodzajŹródła];
        st = new SubTable(st, okres);
        foreach (WypElement e in st) {
            try {
                ps -= e.Okres;
            }
            catch { msg = true; }
        }
        
        bool any = false;
        foreach (FromTo o in ps) {
            if (!any)
                colElement.AddLine(definicja==null ? "?" : definicja.ToString());
            else
                colElement.AddLine("&nbsp;");
            colOkres.AddLine(o);
            any = true;
        }
        return any;
    }
		        
    public static void Msg(object value) {
    }
		    
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="ProstaListaPłac" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" RightMargin="-1" LeftMargin="-1" OnContextLoad="dc_ContextLoad"></ea:datacontext>
			<cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" title="Lista nierozliczonych elementów|&lt;/strong&gt;Wydział: &lt;strong&gt;{0}|&lt;/strong&gt;Pośrednio: &lt;strong&gt;{1}|&lt;/strong&gt;Okres: &lt;strong&gt;{2}|&lt;/strong&gt;Data aktualności: &lt;strong&gt;{3}|&lt;/strong&gt;Źródło wypłaty: &lt;strong&gt;%ŹRÓDŁO%%DEFINICJA%"
				runat="server" DataMember1="KadryPracownicyViewInfo+PrParams.Pośrednio" 
                DataMember0="KadryPracownicyViewInfo+PrParams.Wydział" 
                DataMember2="KadryPracownicyViewInfo+PrParams.Okres" 
                DataMember3="KadryPracownicyViewInfo+PrParams.Aktualny"></cc1:reportheader>
			<ea:Grid id="Grid" runat="server" onbeforerow="Grid_BeforeRow" 
                RowTypeName="Soneta.Kadry.Pracownik,Soneta.KadryPlace">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp" VAlign="Top"></ea:GridColumn>
					<ea:GridColumn DataMember="NazwiskoImię" Total="Info" 
                        Caption="Pracownik~Nazwisko i imię"></ea:GridColumn>
					<ea:GridColumn Caption="Pracownik~Kod" DataMember="Kod"></ea:GridColumn>
					<ea:GridColumn ID="colElement" runat="server" Caption="Element">
                    </ea:GridColumn>
					<ea:GridColumn Width="21" Caption="Okres" ID="colOkres"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False">
			</cc1:reportfooter>
		</form>
	</body>
</HTML>
